package mcfall.raytracer.objects;

import java.util.List;

import mcfall.math.Point;
import mcfall.math.Ray;

/**
 * A generic cylinder is a cylinder located along the z axis, for -1 &lt;= z &lt;= 1
 * @author mcfall
 *
 */
public class GenericCylinder extends AbstractBoundingBox {

	public GenericCylinder () {
		super(new Point(0d,0d,.5d), new Point(2d,2d,1d));
	}
	
	/**
	 * Constructs a GenericCylinder object with the given name
	 * @param name the name to associate with this object
	 */
	public GenericCylinder (String name) {
		super(name,new Point(0d,0d,.5d), new Point(2d,2d,1d));
	}
	
	@Override
	protected List<HitRecord> genericHitTime(Ray ray) {
		return new java.util.ArrayList<HitRecord> ();
	}

	@Override
	protected String getObjectType() {
		return ("Generic Cylinder");
	}

	
}
